/**
* \file: WaylandSurface.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Digital iPod Out - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef DIPO_WAYLANDSURFACE_H
#define DIPO_WAYLANDSURFACE_H

#include "WaylandContext.h"

namespace adit { namespace carplay
{

class DIPO_WL_HIDDEN_SYMBOL WaylandSurface
{
public:
    WaylandSurface();
    ~WaylandSurface();

    bool Create(WaylandContext* inContext, uint32_t inWidth, uint32_t inHeight,
            uint32_t inLayerId, uint32_t inSurfaceId);

private:
    WaylandContext* context;

    struct wl_surface* surface;
    struct wl_buffer *buffer;
    struct compositor_shim_surface_context adapterSurfaceContext;
    void *shm_data;
    int shm_size;
    uint32_t surfaceId;
};

} } /* namespace adit { namespace carplay */

#endif /* DIPO_WAYLANDSURFACE_H */
